<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Trunking
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Trunking\V1\Trunk;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Serialize;


class OriginationUrlContext extends InstanceContext
    {
    /**
     * Initialize the OriginationUrlContext
     *
     * @param Version $version Version that contains the resource
     * @param string $trunkSid The SID of the Trunk to associate the resource with.
     * @param string $sid The unique string that we created to identify the OriginationUrl resource to delete.
     */
    public function __construct(
        Version $version,
        $trunkSid,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'trunkSid' =>
            $trunkSid,
        'sid' =>
            $sid,
        ];

        $this->uri = '/Trunks/' . \rawurlencode($trunkSid)
        .'/OriginationUrls/' . \rawurlencode($sid)
        .'';
    }

    /**
     * Delete the OriginationUrlInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {

        return $this->version->delete('DELETE', $this->uri);
    }


    /**
     * Fetch the OriginationUrlInstance
     *
     * @return OriginationUrlInstance Fetched OriginationUrlInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): OriginationUrlInstance
    {

        $payload = $this->version->fetch('GET', $this->uri, [], []);

        return new OriginationUrlInstance(
            $this->version,
            $payload,
            $this->solution['trunkSid'],
            $this->solution['sid']
        );
    }


    /**
     * Update the OriginationUrlInstance
     *
     * @param array|Options $options Optional Arguments
     * @return OriginationUrlInstance Updated OriginationUrlInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): OriginationUrlInstance
    {

        $options = new Values($options);

        $data = Values::of([
            'Weight' =>
                $options['weight'],
            'Priority' =>
                $options['priority'],
            'Enabled' =>
                Serialize::booleanToString($options['enabled']),
            'FriendlyName' =>
                $options['friendlyName'],
            'SipUrl' =>
                $options['sipUrl'],
        ]);

        $payload = $this->version->update('POST', $this->uri, [], $data);

        return new OriginationUrlInstance(
            $this->version,
            $payload,
            $this->solution['trunkSid'],
            $this->solution['sid']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Trunking.V1.OriginationUrlContext ' . \implode(' ', $context) . ']';
    }
}
